/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.ai.goals.jobs;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.ai.goals.Goal;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalException;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.ItemCreatedCallback;
import technology.rocketjump.undermount.entities.model.physical.humanoid.EquippedItemComponent;
import technology.rocketjump.undermount.entities.model.physical.humanoid.InventoryComponent;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;
import technology.rocketjump.undermount.messaging.types.ItemCreationRequestMessage;

public class EquipItemGoal
extends Goal
implements ItemCreatedCallback {
    private final MessageDispatcher messageDispatcher;
    private final ItemType requiredItemType;
    private boolean itemCreationRequested;

    public EquipItemGoal(Entity parentEntity, MessageDispatcher messageDispatcher, ItemType itemTypeRequiredForWork) {
        super(parentEntity);
        this.messageDispatcher = messageDispatcher;
        this.requiredItemType = itemTypeRequiredForWork;
    }

    @Override
    public void update(float deltaTimeSeconds) throws GoalException {
        InventoryComponent inventoryComponent = this.parentEntity.getOrCreateComponent(InventoryComponent.class);
        Entity itemInInventory = inventoryComponent.getItemByType(this.requiredItemType);
        if (itemInInventory != null) {
            inventoryComponent.removeItem(itemInInventory);
            EquippedItemComponent equippedItemComponent = this.parentEntity.getOrCreateComponent(EquippedItemComponent.class);
            equippedItemComponent.setEquippedItem(itemInInventory, this.messageDispatcher);
        } else if (!this.itemCreationRequested) {
            this.messageDispatcher.dispatchMessage(703, new ItemCreationRequestMessage(this.requiredItemType, this));
            this.itemCreationRequested = true;
        }
    }

    @Override
    public boolean isComplete() {
        ItemEntityAttributes equippedItemAttributes;
        EquippedItemComponent equippedItemComponent = this.parentEntity.getComponent(EquippedItemComponent.class);
        return equippedItemComponent != null && equippedItemComponent.getEquippedItem() != null && (equippedItemAttributes = (ItemEntityAttributes)equippedItemComponent.getEquippedItem().getPhysicalEntityComponent().getAttributes()).getItemType().equals(this.requiredItemType);
    }

    @Override
    public void itemCreated(Entity item) {
        EquippedItemComponent equippedItemComponent = this.parentEntity.getOrCreateComponent(EquippedItemComponent.class);
        item.getLocationComponent().setOrientation(this.parentEntity.getLocationComponent().getOrientation());
        equippedItemComponent.setEquippedItem(item, this.messageDispatcher);
    }
}

